<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddReferenceFieldsToCashbooksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cashbooks', function (Blueprint $table) {
            $table->string('reference_type')->nullable()->after('note')->comment('Model class that created this entry');
            $table->unsignedBigInteger('reference_id')->nullable()->after('reference_type')->comment('ID of the source record');
            $table->boolean('is_opening_balance')->default(false)->after('reference_id')->comment('Is this the opening balance entry');
            
            $table->index(['reference_type', 'reference_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cashbooks', function (Blueprint $table) {
            $table->dropIndex(['reference_type', 'reference_id']);
            $table->dropColumn(['reference_type', 'reference_id', 'is_opening_balance']);
        });
    }
}
