<?php
namespace App\Traits;

trait AutoUpdateTrait{
    /*
    |============================================================
    | # For Version Upgrade - you should follow these point in DEMO :
    |       1. clientVersionNumber >= minimumRequiredVersion
    |       2. latestVersionUpgradeEnable === true
    |       3. demoVersionNumber > clientVersionNumber
    |
    |===========================================================
    */
    public function isUpdateAvailable()
    {
        // Bypass update check - return empty data to disable update notifications
        $versionUpgradeData = [];
        $versionUpgradeData['alert_version_upgrade_enable'] = false;
        $versionUpgradeData['demo_version'] = env('VERSION', '5.5.3');
        $versionUpgradeData['latest_version_db_migrate_enable'] = false;
        $versionUpgradeData['advertise_info'] = '';

        return $versionUpgradeData;
    }

    private function stringToNumberConvert($dataString) {
        $myArray = explode(".", $dataString);
        $versionString = "";
        foreach($myArray as $element) {
          $versionString .= $element;
        }
        $versionConvertNumber = intval($versionString);
        return $versionConvertNumber;
    }

    public function versionUpgradeFileUrl($purchaseCode)
    {
        // Bypass purchase code verification for version upgrade
        // Return a dummy URL - you'll need to manually upload upgrade files
        // Or set to null to skip auto-update feature
        $version_upgrade_file_url = null;
        
        // If you want to enable manual updates, you can return a local path or URL
        // $version_upgrade_file_url = 'https://example.com/path/to/upgrade.zip';
        
        return $version_upgrade_file_url;
    }
}
