<?php

namespace App\Observers;

use App\Models\Income;
use App\Services\CashbookService;

class IncomeObserver
{
    protected $cashbookService;

    public function __construct(CashbookService $cashbookService)
    {
        $this->cashbookService = $cashbookService;
    }

    /**
     * Handle the Income "created" event.
     *
     * @param  \App\Models\Income  $income
     * @return void
     */
    public function created(Income $income)
    {
        $this->cashbookService->createFromIncome($income);
    }

    /**
     * Handle the Income "updated" event.
     *
     * @param  \App\Models\Income  $income
     * @return void
     */
    public function updated(Income $income)
    {
        $this->cashbookService->updateEntry(
            get_class($income),
            $income->id,
            [
                'amount' => $income->amount,
                'date' => $income->created_at,
                'note' => $income->note,
            ]
        );
    }

    /**
     * Handle the Income "deleted" event.
     *
     * @param  \App\Models\Income  $income
     * @return void
     */
    public function deleted(Income $income)
    {
        $this->cashbookService->deleteEntry(get_class($income), $income->id);
    }
}
