<?php

namespace App\Observers;

use App\Models\ReturnPurchase;
use App\Services\CashbookService;

class ReturnPurchaseObserver
{
    protected $cashbookService;

    public function __construct(CashbookService $cashbookService)
    {
        $this->cashbookService = $cashbookService;
    }

    /**
     * Handle the ReturnPurchase "created" event.
     *
     * @param  \App\Models\ReturnPurchase  $returnPurchase
     * @return void
     */
    public function created(ReturnPurchase $returnPurchase)
    {
        $this->cashbookService->createFromPurchaseReturn($returnPurchase);
    }

    /**
     * Handle the ReturnPurchase "updated" event.
     *
     * @param  \App\Models\ReturnPurchase  $returnPurchase
     * @return void
     */
    public function updated(ReturnPurchase $returnPurchase)
    {
        $this->cashbookService->updateEntry(
            get_class($returnPurchase),
            $returnPurchase->id,
            [
                'amount' => $returnPurchase->grand_total,
                'date' => $returnPurchase->created_at,
            ]
        );
    }

    /**
     * Handle the ReturnPurchase "deleted" event.
     *
     * @param  \App\Models\ReturnPurchase  $returnPurchase
     * @return void
     */
    public function deleted(ReturnPurchase $returnPurchase)
    {
        $this->cashbookService->deleteEntry(get_class($returnPurchase), $returnPurchase->id);
    }
}
