<?php

namespace App\Observers;

use App\Models\Expense;
use App\Services\CashbookService;

class ExpenseObserver
{
    protected $cashbookService;

    public function __construct(CashbookService $cashbookService)
    {
        $this->cashbookService = $cashbookService;
    }

    /**
     * Handle the Expense "created" event.
     *
     * @param  \App\Models\Expense  $expense
     * @return void
     */
    public function created(Expense $expense)
    {
        $this->cashbookService->createFromExpense($expense);
    }

    /**
     * Handle the Expense "updated" event.
     *
     * @param  \App\Models\Expense  $expense
     * @return void
     */
    public function updated(Expense $expense)
    {
        $this->cashbookService->updateEntry(
            get_class($expense),
            $expense->id,
            [
                'amount' => $expense->amount,
                'date' => $expense->created_at,
                'note' => $expense->note,
            ]
        );
    }

    /**
     * Handle the Expense "deleted" event.
     *
     * @param  \App\Models\Expense  $expense
     * @return void
     */
    public function deleted(Expense $expense)
    {
        $this->cashbookService->deleteEntry(get_class($expense), $expense->id);
    }
}
